async function activateItem(bot, itemName) {
    const itemByName = mcData.itemsByName[itemName];

    if (!itemByName) {
        throw new Error(`No item named ${itemName}`);
    }

    const item = bot.inventory.findInventoryItem(itemByName.id);
    if (!item) {
        bot.chat(`No ${itemName} in inventory`);
        console.log(`No ${itemName} in inventory`);
        return;
    }

    try {
        await bot.equip(item, "hand");
        await bot.activateItem();
        bot.chat(`Activated ${itemName}`);
        console.log(`Activated ${itemName}`);
    } catch (error) {
        console.error(error);
        
    }
    return;
}